% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_camp.R
\name{bitly_update_channel}
\alias{bitly_update_channel}
\title{Update A Channel (Premium)}
\usage{
bitly_update_channel(
  channel_guid = NULL,
  group_guid = NULL,
  guid = NULL,
  name = NULL,
  modified = NULL,
  created = NULL,
  campaign_guid = NULL,
  bitlink_id = NULL,
  showRequestURL = T
)
}
\arguments{
\item{channel_guid}{- GUID of a target channel}

\item{group_guid}{- a GUID for a Bitly group}

\item{guid}{- ID for a channel}

\item{name}{- its name}

\item{modified}{- string | ISO_TIMESTAMP}

\item{created}{- string | ISO TIMESTAMP}

\item{campaign_guid}{- string | A GUID for a Bitly campaign}

\item{bitlink_id}{- string}

\item{showRequestURL}{- an optional T/F value to whether show URL which has been
build and requested from server. For debug purposes, default FALSE.}
}
\description{
Update an existing Channel
}
\note{
It has not been tested, see readme file on GitHub \url{https://github.com/dmpe/urlshorteneR/}
}
\section{Campaigns}{

Bitly Campaigns allows you to build and manage omnichannel campaigns.
}

\examples{
\dontrun{
uc <- bitly_update_channel(channel_guid = "testing", group_guid = "", name = "name")
}

}
\seealso{
\url{https://dev.bitly.com/v4/#operation/updateChannel}
}
