% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instantiate_prefab.R
\name{instantiate_prefab}
\alias{instantiate_prefab}
\title{Add a prefab to a Unity scene}
\usage{
instantiate_prefab(
  script,
  method_name = NULL,
  destination_scene = NULL,
  prefab_path,
  x_position = 0,
  y_position = 0,
  z_position = 0,
  x_scale = 1,
  y_scale = 1,
  z_scale = 1,
  x_rotation = 0,
  y_rotation = 0,
  z_rotation = 0,
  exec = TRUE
)
}
\arguments{
\item{script}{A \code{unifir_script} object, created by \link{make_script} or returned
by an \verb{add_prop_*} function.}

\item{method_name}{The internal name to use for the C# method created. Will
be randomly generated if not set.}

\item{destination_scene}{Optionally, the scene to instantiate the prefabs
in. Ignored if NULL, the default.}

\item{prefab_path}{File path to the prefab to be instantiated. This should
be relative to the Unity project root directory, and likely begins with
"Assets". Alternatively, if this is one of the elements in}

\item{x_position, y_position, z_position}{The position of the GameObject in
world space.}

\item{x_scale, y_scale, z_scale}{The scale of the GameObject (relative to its
parent object).}

\item{x_rotation, y_rotation, z_rotation}{The rotation of the GameObject to
create, as Euler angles.}

\item{exec}{Logical: Should the C# method be included in the set executed by
MainFunc?}
}
\description{
This function creates objects (specifically, prefabs) within a Unity scene.
This function is vectorized over all functions from \code{prefab_path} through
\code{z_rotation}; to add multiple objects, simply provide vectors to each
argument. Note that all arguments will be automatically recycled if not the
same length; this may produce undesired results. This function is only
capable of altering a single scene at once -- call the function multiple
times if you need to manipulate multiple scenes.
}
\examples{
# First, create a script object.
# CRAN doesn't have Unity installed, so pass
# a waiver object to skip the Unity-lookup stage:
script <- make_script("example_script", unity = waiver())

# Now add props:
script <- instantiate_prefab(script, prefab_path = "Assets/some.prefab")

# Lastly, execute the script via the `action` function
}
\seealso{
Other props: 
\code{\link{add_default_player}()},
\code{\link{add_light}()},
\code{\link{add_prop}()},
\code{\link{add_texture}()},
\code{\link{create_terrain}()},
\code{\link{import_asset}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{new_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{validate_path}()}
}
\concept{props}
