% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Manitoba.R
\docType{data}
\name{manitoba_1}
\alias{manitoba_1}
\title{Primary colors of the University of Manitoba, Canada}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on the
\href{https://umanitoba.ca/sites/default/files/2019-12/UM_Brand-Guidelines.pdf}{UM-Guidelines (PDF)}.
}
\usage{
manitoba_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{maitoba_1} provides the four primary colors 
of the \href{https://umanitoba.ca/}{University of Manitoba}, Canada.
}
\details{
The four primary colors are
\code{"brown_manitoba"}, defined as RGB 79/44/29, HEX #4F2C1D),
\code{"gold_manitoba"} (defined as RGB 242/169/0, HEX #F2A900),
\code{"medium_blue_manitoba"} (defined as RGB 56/94/157, HEX #385E9D), and
\code{"light_blue_manitoba"} (defined as RGB 0/163/224, HEX #00A3E0).

\code{manitoba_1} uses the HEX color definitions.
}
\examples{
manitoba_1
unikn::seecol(manitoba_1, 
              main = "Primary colors of the University of Manitoba") 

}
\seealso{
\code{\link{manitoba_2}} for the extended colors of the University of Manitoba; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-07-04.
}
\concept{Canadian university color palettes}
\keyword{datasets}
