% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McGill.R
\docType{data}
\name{mcgill_brights}
\alias{mcgill_brights}
\title{Bright colours of McGill University, Canada}
\format{
An object of class \code{character} of length 6.
}
\source{
Colour definitions are based on the
\href{https://www.mcgill.ca/visual-identity/visual-identity-guide}{Visual Identity Guide}.
}
\usage{
mcgill_brights
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
McGill’s secondary colours, are not official but rather suggested colours that cover a larger spectrum to complement the McGill red.
They can be used to add variety and contrast for headings, bullets, background and other graphic elements.
}
\details{
\code{mcgill_brights} provides the bright colours 
of \href{https://www.mcgill.ca/}{McGill University}, Canada.

The bright colours are 
\code{"bright_1"} (defined as CMYK 0/50/100/0, RGB 247/148/29, HEX #F7941D),
\code{"bright_2"} (defined as CMYK 0/15/100/0, RGB 255/212/0, HEX #FFD400),
\code{"bright_3"} (defined as CMYK 70/0/30/0, RGB 39/189/190, HEX #27BDBE),
\code{"bright_4"} (defined as CMYK 60/0/0/0, RGB 68/200/245, HEX #44C8F5),
\code{"bright_5"} (defined as CMYK 35/0/100/0, RGB 178/210/53, HEX #B2D235), and
\code{"bright_6"} (defined as CMYK 20/72/0/0, RGB 199/104/169, HEX #C768A9).

\code{mcgill_brights} uses the HEX colour definition. 
CMYK colour differs from RGB and HEX definition.
}
\examples{
mcgill_brights
unikn::seecol(mcgill_brights, main = "Bright colours of McGill") # view colour palette

}
\seealso{
\code{\link{mcgill_red}} for the primary colour of McGill University;
\code{\link{mcgill_pastels}} for the pastel colours of McGill;
\code{\link{mcgill_muted}} for the muted colours of McGill;
\code{\link{mcgill_darks}} for the dark colours of McGill;
\code{\link{mcgill_grey}} for the grey of McGill;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc_1}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-20.
}
\concept{Canadian university color palettes}
\keyword{datasets}
