% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANU.R
\docType{data}
\name{ANU_2}
\alias{ANU_2}
\title{Font colours of Australian National University, Australia}
\format{
An object of class \code{character} of length 4.
}
\source{
ANU's \href{https://webpublishing.anu.edu.au/web-style-guide/colours}{Web Style Guide: Colours}.
}
\usage{
ANU_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{ANU_2} provides the four font colors 
of the \href{https://www.anu.edu.au}{Australian National University}, Canberra, Australia.
}
\details{
ANU's primary colour is \code{ANU gold}, defined as HEX \code{"#BE830E"}, 
but the default font colour is \code{"black"}, or HEX \code{"#000000"}.


ANU has several alternative font colours that are approved to use on ANU websites. 
See ANU's \href{https://webpublishing.anu.edu.au/web-style-guide/text}{Web Style Guide: Text}
for corresponding class names. 

Please ensure that any combination of font and background colours passes the WCAG 2.1 accessibility check. 
(see the \href{https://webpublishing.anu.edu.au/web-style-guide/accessibility}{Accessibility section} 
for approved colour combinations).
}
\examples{
ANU_2
unikn::seecol(ANU_2, main = "Font colours of Australian National University")

}
\seealso{
\code{\link{ANU_1}} for background colours of Australian National University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Australian university color palettes: 
\code{\link{ANU_1}},
\code{\link{mq_1}},
\code{\link{mq_2}},
\code{\link{wollongong_1}},
\code{\link{wollongong_2}}
}
\author{
\strong{unicol}, 2023-09-04.
}
\concept{Australian university color palettes}
\keyword{datasets}
