% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_is_numeric}
\alias{umx_is_numeric}
\title{Check if variables in a dataframe are numeric}
\usage{
umx_is_numeric(df, all = TRUE)
}
\arguments{
\item{df}{A dataframe to check}

\item{all}{Whether to return a single all() Boolean or each column individually.}
}
\value{
\itemize{
\item Boolean or Boolean vector
}
}
\description{
Checks across columns of a dataframe, return a vector of TRUE and FALSE,
or, if all ==TRUE, a single binary (the default).
}
\examples{
umx_is_numeric(mtcars) # TRUE
umx_is_numeric(mtcars, all=FALSE) # vector of TRUE
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=umx_is_class]{umx_is_class()}}
}

Other Check or test: 
\code{\link{umx_check_names}()},
\code{\link{umx_is_class}()},
\code{\link{umx_is_endogenous}()},
\code{\link{umx_is_exogenous}()},
\code{\link{umx_is_ordered}()},
\code{\link{umx}}
}
\concept{Check or test}
