% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_get_bracket_addresses}
\alias{umx_get_bracket_addresses}
\title{Get bracket-style addresses from an mxMatrix}
\usage{
umx_get_bracket_addresses(mat, free = NA, newName = NA)
}
\arguments{
\item{mat}{an mxMatrix to get address labels from}

\item{free}{how to filter on free (default = NA: take all)}

\item{newName}{= NA}
}
\value{
\itemize{
\item a list of bracket style labels
}
}
\description{
Sometimes you want these :-) This also allows you to change the matrix name: useful for using mxMatrix addresses in an mxAlgebra.
}
\examples{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("get_add_ex", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)#'
umx_get_bracket_addresses(m1$matrices$A, free= TRUE)
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Advanced Model Building Functions: \code{\link{umxJiggle}()},
  \code{\link{umxLabel}()}, \code{\link{umxRAM2Ordinal}()},
  \code{\link{umxThresholdMatrix}()},
  \code{\link{umxValues}()},
  \code{\link{umx_fix_first_loadings}()},
  \code{\link{umx_fix_latents}()},
  \code{\link{umx_string_to_algebra}()}, \code{\link{umx}}
}
\concept{Advanced Model Building Functions}
