% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxWeightedAIC}
\alias{umxWeightedAIC}
\title{AIC weight-based conditional probabilities.}
\usage{
umxWeightedAIC(models, digits = 2)
}
\arguments{
\item{models}{a list of models to compare.}

\item{digits}{(default 2)}
}
\value{
- Best model
}
\description{
Returns the best model by AIC, and computes the probabilities 
according to AIC weight-based conditional probabilities (Wagenmakers & Farrell, 2004).
}
\examples{
l1 = lm(mpg~ wt + disp, data=mtcars)
l2 = lm(mpg~ wt, data=mtcars)
umxWeightedAIC(models = list(l1, l2))
}
\references{
- Wagenmakers E.J., Farrell S. (2004), 192-196. AIC model selection using Akaike weights. *Psychonomic Bulletin and Review*. **11**, 192-196. \url{https://www.ncbi.nlm.nih.gov/pubmed/15117008}
}
\seealso{
- \code{\link{AIC}}

Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{tmx_is.identified}}, \code{\link{umxAPA}},
  \code{\link{umxEval}}, \code{\link{umxFactorScores}},
  \code{\link{umxGetParameters}}, \code{\link{umxReduce}},
  \code{\link{umxSummary}}, \code{\link{umx_APA_model_CI}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_aggregate}},
  \code{\link{umx_names}}, \code{\link{umx_parameters}},
  \code{\link{umx_print}},
  \code{\link{umx_show_fit_or_comparison}},
  \code{\link{umx_show}}, \code{\link{umx_time}},
  \code{\link{umx}}
}
\concept{Reporting Functions}
