% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmx.R
\name{tmx_genotypic_effect}
\alias{tmx_genotypic_effect}
\title{Graphical display of genotypic effects.}
\usage{
tmx_genotypic_effect(p = 0.75, q = (1 - p), a = 0.5, d = 0.25,
  m = 0, show = TRUE)
}
\arguments{
\item{p}{The frequency of the A allele (Default .5)}

\item{q}{The frequency of the a allele (Default 1-p)}

\item{a}{Half the difference between the AA and aa homozygotes (Default .5)}

\item{d}{The deviation of the heterozygote from m (Default 1)}

\item{m}{The value of the midpoint between the homozygotes (Default 0)}

\item{show}{Whether to draw the plot or just return it (Default = TRUE)}
}
\value{
-
}
\description{
tmx_genotypic_effect allows you to explore the concept of genotypic effect at a locus.
The d and h increments of the gene difference A – a. Aa may lie on either side of m and the sign of h will
vary accordingly; in the case illustrated h would be negative. (Adapted from Mather and Jinks, 1977, p. 32).
See book issue 23
This function lets you explore the simplest two–allele system (B and b), with three possible genotypes, BB, Bb, and bb.
Parameter "b" is half the measured difference between the homozygotes BB and bb. The point between the two homozygotes 
is "m" -- the mean effect of homozygous genotypes. "d" defines the measured deviation effect of the heterozygote Aa, 
relative to this expected midpoint. "a" and "d" are genotypic effects.

old system:

$d$ =  half the homozygotes difference (midpoint = $m$)

$h$ = measured deviation of the heterozygote from $m$

new system:

u, v -> p, q

d, h -> a, d

Neale, M. C. (2005). Quantitative Genetics. In Encyclopedia of Life Sciences. New York: John Wiley & Sons, Ltd.
https://github.com/tbates/BGBook/issues/23#issuecomment-333834075
}
\examples{
library(umx);
tmx_genotypic_effect(p = .5, q =.5, a =.5, d = 1, m = 0)

# ================
# = No dominance =
# ================
tmx_genotypic_effect(p = .5, a = 1, d = 0, m = 0, show = TRUE);

# ======================
# = Complete dominance =
# ======================
tmx_genotypic_effect(p = .5, a = 1, d = 0, m = 0, show = TRUE);

p = tmx_genotypic_effect(p = .5, q = .5, a = 1, d = .0, m = 0, show = TRUE);
p = tmx_genotypic_effect(p = .5, q = .5, a = 1, d = .5, m = 0, show = TRUE); 
p
# p + geom_point() + geom_text(hjust = 0, nudge_x = 0.05)
# ggsave(paste0(base, "c03_genotypic_effect_by_gene_dose.pdf"), width = 4.6, height = 4.6)
}
\references{
- \url{https://vipbg.vcu.edu/vipbg/Articles/2005_book_chapters_ascertainment_corrections.pdf},
 \url{https://github.com/tbates/umx}
}
\seealso{
-

Other Teaching and testing Functions: \code{\link{tmx_is.identified}},
  \code{\link{umx}}
}
\concept{Teaching and testing Functions}
