% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxRAM}
\alias{umxRAM}
\title{umxRAM}
\usage{
umxRAM(name, data = NULL, ..., run = TRUE, exog.variances = FALSE,
  endog.variances = FALSE, latentVars = NULL, setValues = TRUE,
  independent = NA, remove_unused_manifests = TRUE, fix = "deprecated")
}
\arguments{
\item{name}{A friendly name for the model}

\item{data}{the data for the model. Can be an \code{\link{mxData}} or a data.frame}

\item{...}{A list of mxPath, umxPath, or mxThreshold objects}

\item{run}{Whether to mxRun the model (defaults to TRUE: the estimated model will be returned)}

\item{exog.variances}{If TRUE, free variance parameters are added for exogenous variables that lack them (the default is FALSE).}

\item{endog.variances}{If TRUE, free error-variance parameters are added for any endogenous variables that lack them (default is FALSE).}

\item{latentVars}{Latents you want in your model (defaults to NULL, in which case any variable not in the data is assumed to be a latent variable)}

\item{setValues}{Whether to try and guess good start values (Defults to TRUE, set them)}

\item{independent}{Whether the model is independent (default = NA)}

\item{remove_unused_manifests}{Whether to remove variables in the data to which no path makes reference (defaults to TRUE)}

\item{fix}{deprecated. use umxPath(fixedAt = etc.}
}
\value{
- \code{\link{mxModel}}
}
\description{
Making it as simple as possible to create a RAM model, without doing invisible things to the user.
}
\details{
Like \code{\link{mxModel}}, you list the theoretical causal paths. Unlike mxModel:
\enumerate{
\item{type defaults to "RAM"}
\item{You don't need to list manifestVars (they are detected from path usage)}
\item{You don't need to list latentVars (detected as anything in paths but not in \code{mxData})}
\item{You add data like you do in \code{\link{lm}}, with \strong{data = }}
\item{with \code{\link{umxPath}} you can use powerful verbs like \strong{var = }}
}

\strong{Comparison with other software}

Some software has massive behind-the-scenes defaulting and path addition. I've played with some
similar features (like auto-creating error and exogenous variances using \code{endog.variances = TRUE}
and \code{exog.variances = TRUE}). Also identification helpers like \code{fix = "latents"}
and \code{fix = "firstLoadings"}

To be honest, these are not only more trouble than they are worth, they encourage errors and
poor modelling. I suggest user learn the handful of \code{\link{umxPath}}
short cuts and stay clean and explicit!
}
\examples{
# umxRAM is like ggplot2::qplot(), you give the data in a data =  parameter
# A common error is to include data in the main list,
# a bit like saying lm(y~x + df) instead of lm(y~x, data=dd)...
# nb: unlike mxModel, umxRAM needs data at build time.

# 1. For convenience, list up the manifests you will be using
selVars = c("mpg", "wt", "disp")

# 2. Create an mxData object
myCov = mxData(cov(mtcars[,selVars]), type = "cov", numObs = nrow(mtcars) )

# 3. Create the model (see ?umxPath for more nifty options)
m1 = umxRAM("tim", data = myCov,
	umxPath(c("wt", "disp"), to = "mpg"),
	umxPath(cov = c("wt", "disp")),
	umxPath(var = c("wt", "disp", "mpg"))
)

\dontrun{
# 5. Print a nice summary
umxSummary(m1, show = "std")

# 6. Draw a nice path diagram (needs Graphviz)
plot(m1)
}
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Model Building Functions: \code{\link{umxLabel}};
  \code{\link{umxLatent}}; \code{\link{umxPath}};
  \code{\link{umxReRun}}; \code{\link{umxRun}};
  \code{\link{umxThresholdMatrix}};
  \code{\link{umxValues}};
  \code{\link{umx_fix_first_loadings}};
  \code{\link{umx_fix_latents}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

