% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap.R
\name{umap}
\alias{umap}
\title{Computes a manifold approximation and projection}
\usage{
umap(
  d,
  config = umap.defaults,
  method = c("naive", "umap-learn"),
  preserve.seed = TRUE,
  ...
)
}
\arguments{
\item{d}{matrix, input data}

\item{config}{object of class umap.config}

\item{method}{character, implementation. Available methods are 'naive'
(an implementation written in pure R) and 'umap-learn' (requires python
package 'umap-learn')}

\item{preserve.seed}{logical, leave TRUE to insulate external code from
randomness within the umap algorithms; set FALSE to allow randomness used
in umap algorithms to alter the external random-number generator}

\item{...}{list of settings; values overwrite defaults from config;
see documentation of umap.default for details about available settings}
}
\value{
object of class umap, containing at least a component
with an embedding and a component with configuration settings
}
\description{
Computes a manifold approximation and projection
}
\examples{
# embedd iris dataset using default settings
iris.umap = umap(iris[,1:4])

# display object summary
iris.umap

# display embedding coordinates
head(iris.umap$layout)

}
