% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor_functions.R
\name{extract_biomarkers}
\alias{extract_biomarkers}
\title{Extract NMR metabolomic biomarkers from a data.frame of UK Biobank fields}
\usage{
extract_biomarkers(x)
}
\arguments{
\item{x}{\code{data.frame} with column names "eid" followed by extracted
fields e.g. "23474-0.0", "23474-1.0", \dots, "23467-1.0".}
}
\value{
a \code{data.frame} or \code{data.table} with column names "eid",
        and "visit_index", followed by columns for each biomarker
       e.g. "bOHbutyrate", \dots, "Valine".
}
\description{
Given an input \code{data.frame} loaded from a dataset extracted by
\href{https://biobank.ctsu.ox.ac.uk/crystal/exinfo.cgi?src=accessing_data_guide}{ukbconv}
extracts the \href{https://biobank.ndph.ox.ac.uk/showcase/label.cgi?id=220}{UK Biobank fields}
corresponding to the
\href{https://research.nightingalehealth.com/biomarkers/}{NMR metabolomics biomarkers}
giving them short variable names as listed in the \code{\link{nmr_info}} information data sheet
available in this package.
}
\details{
Data sets extracted by
\href{https://biobank.ctsu.ox.ac.uk/crystal/exinfo.cgi?src=accessing_data_guide}{ukbconv}
have one row per UKB biobank participant whose project specific sample
identifier is given in the first column named "eid". Columns following this
have the format "<field_id>-<visit_index>.<repeat_index>", where here <field_id>
corresponds to a biomarker of interest, e.g. 23474 for 3-Hydroxybutyrate,
<visit_index> corresponds to the assessment time point, e.g. 0 for baseline
assessment, 1 for first repeat visit. For the UKB NMR data, the <repeat_index>
column is reserved for cases where biomarker measurements have more than
one QC Flag (see \code{\link{extract_biomarker_qc_flags}()}).

In the returned \code{data.frame} there is single column for each biomarker,
with an additional column for the visit index. Rows are uniquely identifiable
by the combination of entries in columns "eid" and "visit_index". There are
currently no repeat measure data for the NMR biomarker data in UKB,
so no repeat_index column is returned.

This function will also work with data extracted by the \code{ukbtools} R
package.

If your UK Biobank project only has access to a subset of biomarkers, then
this function will only return the subset of ratios that can be computed from
the biomarker data provided.

A \code{data.table} will be returned instead of a \code{data.frame} if the
the user has loaded the package into their R session.
}
\examples{
ukb_data <- ukbnmr::test_data # Toy example dataset for testing package
nmr <- extract_biomarkers(ukb_data)

}
