% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{wide2long}
\alias{wide2long}
\title{Reshape Column-Based Data to Long Format}
\usage{
wide2long(
  data,
  id_cols = .Tvars[.Tvars \%in\% names(data)],
  to_value = setdiff(names(data), id_cols),
  variable_name = "Series",
  value_name = "Value",
  label_name = "Label",
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{data}{a wide format data frame where all series have their own column.}

\item{id_cols}{character. Temporal identifiers of the data. By default all variables in \code{\link{.Tvars}} are selected.}

\item{to_value}{character. The names of all variables to be stacked into the long format data frame.}

\item{variable_name}{character. The name of the variable to store the names of the series.}

\item{value_name}{character. The name of the variable to store the data values.}

\item{label_name}{character. The name of the variable to store the series labels.}

\item{na.rm}{logical. \code{TRUE} will remove all missing values from the long data frame.}

\item{\dots}{further arguments passed to \code{\link{melt.data.table}}.}
}
\description{
This function automatically reshapes wide (column-based) data into a long format akin to the format of the raw data coming from the database (\code{\link[=get_data]{get_data(..., wide = FALSE)}}).
}
\examples{
\donttest{
# Return monthly macroeconomic indicators from the year 2000 onwards
data <- get_data("BOU_MMI", from = 2000)
wide2long(data)
}
}
\seealso{
\code{\link{long2wide}}, \code{\link{ugatsdb}}
}
