% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranef.R
\name{ranef,ubmsFit-method}
\alias{ranef,ubmsFit-method}
\alias{ranef}
\title{Extract Random Effects}
\usage{
\S4method{ranef}{ubmsFit}(object, submodel, summary = FALSE, add_mean = TRUE, ...)
}
\arguments{
\item{object}{A fitted model of class \code{ubmsFit}}

\item{submodel}{The name of the submodel, as a character string, for
which to generate the random effects}

\item{summary}{If \code{TRUE}, calculate mean, SD, and 95% uncertainty interval
for each random effect term}

\item{add_mean}{If \code{TRUE} (the default) add the overall intercept or
slope mean and return the complete random intercept or slope.}

\item{...}{Currently ignored}
}
\value{
If \code{summary=FALSE}, a list of random effect values; if
 \code{TRUE}, a data frame with columns for random effect mean, SD, and
 95% uncertainty interval lower and upper bounds.
}
\description{
Extract random effects from a \code{ubmsFit} model. Note that this function
works like \code{ranef} for \code{merMod} objects from \code{lme4}, not like
\code{ranef} for \code{unmarkedFit} objects. To get functionality similar
to that of \code{unmarkedFit}, use \code{posterior_predict}.
}
\details{
Note: by default this function adds the overall intercept or slope
to the (mean-0) random effect to get the complete random intercept or slope.
In this way the output is more like the output of \code{lme4::coef}
and not \code{lme4::ranef}. You can turn this off and return just the
mean-0 random effect by setting argument \code{add_mean = FALSE}.

If you run \code{ranef} on a submodel with a spatial random effect,
the function will return estimates of parameter \code{eta}.
}
\seealso{
\code{\link[lme4]{ranef}}, \code{\link{posterior_predict}}
}
