% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_posteriors.R
\name{plot_posteriors,ubmsFit-method}
\alias{plot_posteriors,ubmsFit-method}
\alias{plot_posteriors}
\title{Plot Posterior Distributions}
\usage{
\S4method{plot_posteriors}{ubmsFit}(object, pars = NULL, density = FALSE, ...)
}
\arguments{
\item{object}{A fitted model of class \code{ubmsFit}}

\item{pars}{A character vector of parameter names to include in the plot
Look at \code{names(object@stanfit)} for the complete list of possible
parameter names. If \code{NULL}, posteriors are shown for all parameters
in the model summary output}

\item{density}{If \code{TRUE}, show posteriors as density plots (one per
chain). If \code{FALSE}, show posteriors as histograms of samples from
all chains combined}

\item{...}{Arguments passed to \code{ggplot2::stat_density} for density
plots, or \code{ggplot2::geom_histogram} for histograms. For example, you
can supply argument \code{bins} to control the number of histogram bins}
}
\value{
A \code{ggplot}
}
\description{
Plot posterior distributions for selected parameters. Posteriors can be
represented as density plots or histograms.
}
