% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{md_to_officer}
\alias{md_to_officer}
\title{Parse Markdown for OfficeR}
\usage{
md_to_officer(str)
}
\arguments{
\item{str}{string containing Markdown can contain the following elements:
\itemize{
 \item paragraph    Two or more new lines creates a paragraph
 \item \code{"bold"}    Can be either \code{"*text in bold*"} or \code{"_text in bold_"}
 \item \code{"italic"}  Can be either \code{"**text in bold**"} or \code{"__text in bold__"}
 \item \code{"subscript"}  \code{"Normal~subscript~"} 
 \item \code{"superscript"}  \code{"Normal^superscript^"} 
}}
}
\value{
list with parsed paragraph elements ubiquity system object with the
content added to the body, each paragraph can be found in a numbered list
element (e.g. \code{pgraph_1}, \code{pgraph_2}, etc) each with the following
elements:
\itemize{
 \item \code{locs} Dataframe showing the locations of markdown elements in the current paragraph
 \item \code{pele} These are the individual parsed paragraph elements
 \item \code{fpar_cmd} String containing the fpar_cmd that can be run using
 \code{eval} to return the output of \code{fpar}. For example: 
\preformatted{
  myfpar = eval(parse(text=pgparse$pgraph_1$fpar_cmd))
 }
}
}
\description{
Parses text in Markdown format and returns fpar command strings to be used with OfficeR
}
