% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_crownseg.R
\name{chmseg_ITC}
\alias{chmseg_ITC}
\title{Decision tree segmentation method to grow individual tree crowns based on 'itcSegment'}
\usage{
chmseg_ITC(chm = NULL, EPSG = 3064, movingWin = 7,
  TRESHSeed = 0.45, TRESHCrown = 0.55, minTreeAlt = 2,
  maxCrownArea = 100)
}
\arguments{
\item{chm}{raster*, Canopy height model in \code{raster} or \code{SpatialGridDataFrame} file format. Should be the same that was used to create
the input for \code{treepos}.}

\item{EPSG}{character. The EPSG code of the reference system of the CHM raster image.}

\item{movingWin}{numeric. Size (in pixels) of the moving window to detect local maxima. \href{https://CRAN.R-project.org/package=itcSegment}{itcSegment}}

\item{TRESHSeed}{numeric. seeding threshold. \href{https://CRAN.R-project.org/package=itcSegment}{itcSegment}}

\item{TRESHCrown}{numeric. crowns threshold. \href{https://CRAN.R-project.org/package=itcSegment}{itcSegment}}

\item{minTreeAlt}{numeric. Height threshold (m) below a pixel cannot be a local maximum. Local maxima values are used to define tree tops.\href{https://CRAN.R-project.org/package=itcSegment}{itcSegment}}

\item{maxCrownArea}{numeric. A single value of the maximum projected tree crown area allowed. Default 100 sqm.
height of \code{treepos}.}
}
\description{
Segmentation of individual tree crowns as polygons based on a LiDAR derived canopy height model.
Michele Dalponte: R package \href{https://CRAN.R-project.org/package=itcSegment}{itcSegment}.
 M. Dalponte, F. Reyes, K. Kandare, and D. Gianelle,
 "Delineation of Individual Tree Crowns from ALS and Hyperspectral data: a comparison among four methods,"
 European Journal of Remote Sensing, Vol. 48, pp. 365-382, 2015.
}
\examples{
 require(uavRst)
 data(chm_seg)
##- segmentation
crownsITC<- chmseg_ITC(chm = chm_seg[[1]],
                       EPSG =3064,
                       movingWin = 7,
                       TRESHSeed = 0.45,
                       TRESHCrown = 0.55,
                       minTreeAlt = 5,
                       maxCrownArea = 50)

##- visualisation
raster::plot(crownsITC)
}
