% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_textures.R
\name{otb_stat}
\alias{otb_stat}
\title{Calculates local statistics for a given kernel size}
\usage{
otb_stat(input = NULL, out = "localStat", ram = "8192", radius = 3,
  channel = NULL, retRaster = FALSE, outDir = NULL,
  verbose = FALSE, giLinks = NULL)
}
\arguments{
\item{input}{of GeoTiff containing 1 ore more gray value bands}

\item{out}{string pattern vor individual naming of the output file(s)}

\item{ram}{reserved memory in MB}

\item{radius}{computational window in pixel}

\item{channel}{sequence of bands to be processed}

\item{retRaster}{boolean if TRUE a raster stack is returned}

\item{outDir}{output Directory}

\item{verbose}{switch for system messages default is FALSE}

\item{giLinks}{list. of GI tools cli pathes}
}
\description{
Calculates local statistics for a given kernel size
}
\note{
the otb is used for the calculation of the statistics. Please provide a GeoTiff file
}
\examples{
\dontrun{
require(uavRst)
# check if OTB is installed correctly
giLinks <- uavRst::linkAll()
if (giLinks$otb$exist) {
setwd(tempdir())
data("pacman")
raster::writeRaster(pacman,"pacman.tif",overwrite=TRUE)

# calculate statistics
result<- otb_stat(input="pacman.tif",radius=5,retRaster = TRUE)
#plot the results :
raster::plot(result[[1]])
}
}
}
\author{
Chris Reudenbach
}
