% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikelihood.R
\name{get_alpha_mt}
\alias{get_alpha_mt}
\title{Get mixing weights alpha_mt (this function is for internal use)}
\usage{
get_alpha_mt(
  M,
  log_mvnvalues,
  alphas,
  epsilon,
  conditional,
  to_return,
  also_l_0 = FALSE
)
}
\arguments{
\item{M}{\describe{
  \item{For \strong{GMAR} and \strong{StMAR} models:}{a positive integer specifying the number of mixture components.}
  \item{For \strong{G-StMAR} models:}{a size (2x1) integer vector specifying the number of \emph{GMAR type} components \code{M1} in the
   first element and \emph{StMAR type} components \code{M2} in the second element. The total number of mixture components is \code{M=M1+M2}.}
}}

\item{log_mvnvalues}{\eqn{T x M} matrix containing the log multivariate normal densities.}

\item{alphas}{\eqn{M x 1} vector containing the mixing weight pa}

\item{epsilon}{the smallest number such that its exponent is wont classified as numerically zero
(around \code{-698} is used).}

\item{conditional}{a logical argument specifying whether the conditional or exact log-likelihood function should be used.}

\item{to_return}{should the returned object be the log-likelihood value, mixing weights, mixing weights including
value for \eqn{alpha_{m,T+1}}, a list containing log-likelihood value and mixing weights, the terms \eqn{l_{t}: t=1,..,T}
in the log-likelihood function (see \emph{KMS 2015, eq.(13)}), the densities in the terms, regimewise conditional means,
regimewise conditional variances, total conditional means, total conditional variances, or quantile residuals?}

\item{also_l_0}{return also l_0 (the first term in the exact log-likelihood function)?}
}
\value{
Returns the mixing weights a matrix of the same dimension as \code{log_mvnvalues} so
  that the t:th row is for the time point t and m:th column is for the regime m.
}
\description{
\code{get_alpha_mt} computes the mixing weights based on
  the logarithm of the multivariate normal densities in the definition of
  the mixing weights.
}
\details{
Note that we index the time series as \eqn{-p+1,...,0,1,...,T} as in Kalliovirta et al. (2015).
}
\references{
\itemize{
   \item Galbraith, R., Galbraith, J. 1974. On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
           \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2021. A mixture autoregressive model based on Student's t-distribution.
           \emph{Communications in Statistics - Theory and Methods}, doi: 10.1080/03610926.2021.1916531
   \item Virolainen S. 2021. A mixture autoregressive model based on Gaussian and Student's t-distributions.
         Studies in Nonlinear Dynamics & Econometrics,doi: 10.1515/snde-2020-0060
 }
}
\seealso{
\code{\link{loglikelihood_int}}
}
\keyword{internal}
