% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/documentation.R,
%   R/two_samples.R
\name{wass_stat}
\alias{wass_stat}
\alias{wass_test}
\title{Wasserstein Distance Test}
\usage{
wass_stat(a, b, power = 1)

wass_test(a, b, nboots = 2000, p = default.p)
}
\arguments{
\item{a}{a vector of numbers (or factors -- see details)}

\item{b}{a vector of numbers}

\item{power}{power to raise test stat to}

\item{nboots}{Number of bootstrap iterations}

\item{p}{power to raise test stat to}
}
\value{
Output is a length 2 Vector with test stat and p-value in that order. That vector has 3 attributes -- the sample sizes of each sample, and the number of bootstraps performed for the pvalue.
}
\description{
A two-sample test based on Wasserstein's distance (\code{wass_stat}).
}
\details{
The Wasserstein test compares two ECDFs by looking at the Wasserstein distance between the two. This is of course the area between the two ECDFs. Formally -- if E is the ECDF of sample 1 and F is the ECDF of sample 2, then \deqn{WASS = \int_{x \in R} |E(x)-F(x)|^p}{WASS = Integral |E(x)-F(x)|^p} across all x. The test p-value is calculated by randomly resampling two samples of the same size using the combined sample. Intuitively the Wasserstein test improves on CVM by allowing more extreme observations to carry more weight. At a higher level -- CVM/AD/KS/etc only require ordinal data. Wasserstein gains its power because it takes advantages of the properties of interval data -- i.e. the distances have some meaning.

In the example plot below, the Wasserstein statistic is the shaded area between the ECDFs.

\figure{wass.png}{Example Wasserstein stat plot}

Inputs \code{a} and \code{b} can also be vectors of ordered (or unordered) factors, so long as both have the same levels and orderings. When possible, ordering factors will substantially increase power. \code{wass_test} will assume the distance between adjacent factors is 1.
}
\section{Functions}{
\itemize{
\item \code{wass_stat}: Wasserstein metric between two ECDFs

\item \code{wass_test}: Permutation based two sample test using Wasserstein metric
}}

\examples{
vec1 = rnorm(20)
vec2 = rnorm(20,4)
wass_test(vec1,vec2)

# Example using ordered factors
vec1 = factor(LETTERS[1:5],levels = LETTERS,ordered = TRUE)
vec2 = factor(LETTERS[c(1,2,2,2,4)],levels = LETTERS, ordered=TRUE)
wass_test(vec1,vec2)
}
\seealso{
\code{\link[=dts_test]{dts_test()}} for a more powerful test statistic. See \code{\link[=cvm_test]{cvm_test()}} for the predecessor to this test statistic. See \code{\link[=dts_test]{dts_test()}} for the natural successor of this test statistic.
}
