% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_tvReg.R
\name{confint.tvlm}
\alias{confint.tvlm}
\alias{confint.tvsure}
\alias{confint.tvirf}
\title{Confidence Intervals for Model Parameters of Objects in tvReg}
\usage{
\method{confint}{tvlm}(object, parm, level = 0, runs = 0, tboot = NULL,
  ...)

\method{confint}{tvsure}(object, parm, level = 0, runs = 0, tboot = NULL,
  ...)

\method{confint}{tvirf}(object, parm, level = 0, runs = 0, tboot = NULL,
  ...)
}
\arguments{
\item{object}{Object of class \code{tvsure}, class \code{tvvar} or class \code{tvirf}.}

\item{parm}{A specification of which parameters are to be given confidence intervals, 
either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{Numeric, the confidence level required (between 0 and 1).}

\item{runs}{(optional) Number of bootstrap replications.}

\item{tboot}{Type of wild bootstrap, choices 'wild'(default), 'wild2'. Option 'wild' uses the
distribution suggested by Mammen (1993) in the wild resampling, while 'wild2' uses the standard
normal.}

\item{...}{Other parameters passed to specific methods.}
}
\value{
an object of class \code{tvsure} with BOOT, Lower and Upper different from NULL.
}
\description{
confint is used to estimate the bootstrap confidence intervals for objects with class
attribute \code{tvlm}, \code{tvar}, \code{tvirf}, \code{tvsure}.
}
\examples{

##Calculation of confidence intervals for a tvLM model
tau <- seq(1:500)/500
beta <- data.frame(beta1 = sin(2*pi*tau), beta2= 2*tau)
X1 <- rnorm(500)
X2 <- rchisq(500, df = 4)
error <- rt(500, df = 10)
y <- apply(cbind(X1, X2)*beta, 1, sum) + error
data <- data.frame(y = y, X1 = X1, X2 = X2)
model.tvlm <-  tvLM(y ~ 0 + X1 + X2, data = data, bw = 0.1)
tvci <- confint(model.tvlm, level = 0.95, runs = 30)
plot(tvci)

##The second time is much faster when the level is changed
##if the user uses the previous information
tvci.80 <- confint(tvci, level = 0.8)

}
\references{
Chen, X. B., Gao, J., Li, D., and Silvapulle, P (2017) Nonparametric estimation and 
forecasting for time-varying coefficient realized volatility models,
\emph{Journal of Business \& Economic Statistics}, online, 1-13.

Mammen, E (1993) Bootstrap and wild bootstrap for high dimensional linear models,
\emph{ Annals of Statistics}, 21, 255-285.
}
\seealso{
\code{\link{tvLM}}, \code{\link{tvAR}}, \code{\link{tvVAR}},
\code{\link{tvSURE}}
}
