% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_tutorial.R
\name{format_tutorial}
\alias{format_tutorial}
\title{Format RMarkdown tutorial code chunks}
\usage{
format_tutorial(file_path)
}
\arguments{
\item{file_path}{Character string. Path to the R Markdown file to process.}
}
\value{
Character string containing the formatted R Markdown content.
}
\description{
This function processes an R Markdown tutorial file to standardize code chunk labels
based on section names and exercise numbers. It also renumbers exercises sequentially
within each section.
}
\details{
The function applies the following formatting rules:
\itemize{
\item Exercises are renumbered sequentially within each section
\item Code chunks are relabeled according to the pattern: section-name-exercise-number
\item Chunks with \code{eval = FALSE} receive a \code{-hint-N} suffix
\item Chunks with \code{include = FALSE} receive a \code{-test} suffix
\item Chunks with label "setup" are not modified
\item Chunks with the "file" option are not modified
\item Unlabeled chunks without key options are not modified
\item All formatted chunks preserve their original options
\item Content between quadruple backticks (\verb{ }) is preserved untouched
}
}
\examples{
\dontrun{
# Format a tutorial file
new_content <- format_tutorial("path/to/tutorial.Rmd")

# Write the formatted content to a file
writeLines(new_content, "path/to/formatted_tutorial.Rmd")
}

}
