% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create}
\alias{create}
\title{Create a Dockerfile}
\usage{
create(
  project = here::here(),
  as = file.path(project, "Dockerfile"),
  FROM = NULL,
  ...,
  exclude = NULL,
  verbose = FALSE
)
}
\arguments{
\item{project}{The project directory. If no project directory is provided,
by default, the here package will be used to determine the active
project. If no project is currently active, then here defaults to
the working directory where initially called.}

\item{as}{The file path to write to. The default value is
\code{file.path(project, "Dockerfile")}.}

\item{FROM}{Docker image to start FROM. Default is FROM r-base:R.version.}

\item{...}{Additional arguments which are passed directly to
\link[renv:snapshot]{renv::snapshot}. Please see the documentation for that function for all
relevant details.}

\item{exclude}{A vector of strings specifying all paths (files or
directories) that should NOT be included in the Docker image. By default,
all files in the directory will be included. NOTE: the file and directory
paths should be relative to the project directory. They do NOT need to
be absolute paths.}

\item{verbose}{A boolean indicating whether or not to print the resulting
Dockerfile to the console. Default value is \code{FALSE}.}
}
\value{
The Dockerfile contained as a string vector. Each vector element
corresponds to a line in the Dockerfile.
}
\description{
This function will crawl all files in the current project/directory and
(attempt to) detect all R packages and store these in a lockfile. From this
lockfile, it will create a corresponding Dockerfile. It will also copy
the full contents of the current directory/project into the Docker image.
The directory in the Docker container containing the current directory
contents will be /current-directory-name. For example if your analysis
directory is named \code{incredible_analysis}, the corresponding location in
the generated Docker image will be \verb{/incredible_analysis}.
}
\examples{
\dontrun{
# Create a Dockerfile based on the rocker/rstudio image.
# Write the Dockerfile locally to here::here("Dockerfile").
# Copy all files except the /data and /examples directories.
dock <- create(
  project = here::here(),
  FROM = "rocker/rstudio",
  exclude = c("/data", "/examples")
)
}

}
\seealso{
\link[here:here]{here::here}; this will be used by default to determine the current
project directory.

\link[renv:snapshot]{renv::snapshot} which this function relies on to find all R
dependencies and create a corresponding lockfile.
}
