% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsplot.R
\name{tsplot}
\alias{tsplot}
\title{Plot Time Series}
\usage{
tsplot(..., tsr = NULL, left_as_bar = FALSE, group_bar_chart = FALSE,
  relative_bar_chart = FALSE, plot_title = NULL, plot_subtitle = NULL,
  plot_subtitle_r = NULL, find_ticks_function = "findTicks",
  fill_up_start = FALSE, overall_xlim = NULL, overall_ylim = NULL,
  manual_date_ticks = NULL, manual_value_ticks_l = NULL,
  manual_value_ticks_r = NULL, theme = NULL, quiet = TRUE,
  auto_legend = TRUE)
}
\arguments{
\item{...}{multiple objects of class ts or a list of time series. All objects passed through the ... parameter relate to the standard left y-axis.}

\item{tsr}{list of time series objects of class ts.}

\item{left_as_bar}{logical should the series that relate to the left bar be drawn as (stacked) bar charts?}

\item{group_bar_chart}{logical should a bar chart be grouped instead of stacked?}

\item{relative_bar_chart}{logical Should time series be normalized such that bars range from 0 to 1?}

\item{plot_title}{character title to be added to the plot}

\item{plot_subtitle}{character subtitle to be added to the plot}

\item{plot_subtitle_r}{character second subtitle to be added at the top right}

\item{find_ticks_function}{function to compute ticks.}

\item{fill_up_start}{logical should the start year be filled up?}

\item{overall_xlim}{integer overall x-axis limits, defaults to NULL.}

\item{overall_ylim}{integer overall y-axis limits, defaults to NULL.}

\item{manual_date_ticks}{character vector of manual date ticks.}

\item{manual_value_ticks_l}{numeric vector, forcing ticks to the left y-axis}

\item{manual_value_ticks_r}{numeric vector, forcing ticks to the right y-axis}

\item{theme}{list of default plot output parameters. Defaults to NULL, which leads to \code{\link{init_tsplot_theme}} being called. Please see the vignette for details about tweaking themes.}

\item{quiet}{logical suppress output, defaults to TRUE.}

\item{auto_legend}{logical should legends be printed automatically, defaults to TRUE.}
}
\description{
Conveniently plot time series.
}
