% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/salient.R
\name{salient_mds}
\alias{salient_mds}
\title{Convert salient sequences into MDS space}
\usage{
salient_mds(.mp, data, bit_idx = 1)
}
\arguments{
\item{.mp}{a Matrix Profile object.}

\item{data}{the data used to build the Matrix Profile, if not embedded.}

\item{bit_idx}{an \code{int}. The index of \code{n_bits} used for MDL discretization if more than one was
used. (Default is \code{1}).}
}
\value{
Returns X,Y values for plotting
}
\description{
Convert salient sequences into MDS space
}
\examples{
# toy example
data <- mp_toy_data$data[, 1]
mp <- tsmp(data, window_size = 30, verbose = 0)
mps <- salient_subsequences(mp, verbose = 0)
mds_data <- salient_mds(mps)
plot(mds_data, main = "Multi dimensional scale")
}
\references{
\itemize{
\item Yeh CCM, Van Herle H, Keogh E. Matrix profile III: The matrix profile allows
visualization of salient subsequences in massive time series. Proc - IEEE Int Conf Data Mining,
ICDM. 2017;579-88.
}

\itemize{
\item Hu B, Rakthanmanon T, Hao Y, Evans S, Lonardi S, Keogh E. Discovering the Intrinsic
Cardinality and Dimensionality of Time Series Using MDL. In: 2011 IEEE 11th International
Conference on Data Mining. IEEE; 2011. p. 1086-91.
}

Website: \url{https://sites.google.com/site/salientsubs/}
}
