% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-tile.R
\name{tile2}
\alias{tile2}
\alias{tile2_dfr}
\alias{tile2_dfc}
\alias{ptile}
\alias{ptile_dfr}
\alias{ptile_dfc}
\title{Tiling window calculation over multiple inputs simultaneously}
\usage{
tile2(.x, .y, .f, ..., .size = 1, .bind = FALSE)

tile2_dfr(.x, .y, .f, ..., .size = 1, .bind = FALSE, .id = NULL)

tile2_dfc(.x, .y, .f, ..., .size = 1, .bind = FALSE)

ptile(.l, .f, ..., .size = 1, .bind = FALSE)

ptile_dfr(.l, .f, ..., .size = 1, .bind = FALSE, .id = NULL)

ptile_dfc(.l, .f, ..., .size = 1, .bind = FALSE)
}
\arguments{
\item{.x}{Objects to slide over simultaneously.}

\item{.y}{Objects to slide over simultaneously.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.size}{An integer for window size. If positive, moving forward from left
to right; if negative, moving backward (from right to left).}

\item{.bind}{If \code{.x} is a list, should \code{.x} be combined before applying \code{.f}?
If \code{.x} is a list of data frames, row binding is carried out.}

\item{.id}{Either a string or \code{NULL}. If a string, the output will contain
a variable with that name, storing either the name (if \code{.x} is named) or
the index (if \code{.x} is unnamed) of the input. If \code{NULL}, the default, no
variable will be created.

Only applies to \verb{_dfr} variant.}

\item{.l}{A list of vectors, such as a data frame. The length of \code{.l}
determines the number of arguments that \code{.f} will be called with. List
names will be used if present.}
}
\description{
\lifecycle{defunct}

Please consider using the \href{https://davisvaughan.github.io/slider/}{slider} package.

Tiling window without overlapping observations:
\itemize{
\item \code{tile2()} and \code{ptile()} always returns a list.
\item \code{tile2_lgl()}, \code{tile2_int()}, \code{tile2_dbl()}, \code{tile2_chr()} use the same
arguments as \code{tile2()}, but return vectors of the corresponding type.
\item \code{tile2_dfr()} \code{tile2_dfc()} return data frames using row-binding & column-binding.
}
}
\seealso{
Other tiling window functions: 
\code{\link{tile}()}
}
\concept{tiling window functions}
\keyword{internal}
\alias{tile2_lgl}
\alias{tile2_chr}
\alias{tile2_dbl}
\alias{tile2_int}
\alias{ptile_lgl}
\alias{ptile_chr}
\alias{ptile_dbl}
\alias{ptile_int}
