% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-verbs.R
\name{mutate.tbl_ts}
\alias{mutate.tbl_ts}
\alias{transmute.tbl_ts}
\title{Add new variables}
\usage{
\method{mutate}{tbl_ts}(.data, ..., .drop = FALSE)

\method{transmute}{tbl_ts}(.data, ..., .drop = FALSE)
}
\arguments{
\item{.data}{A tsibble.}

\item{...}{Name-value pairs of expressions.}

\item{.drop}{\code{FALSE} returns a tsibble object as the input. \code{TRUE} drops a
tsibble and returns a tibble.}
}
\description{
\code{mutate()} adds new variables; \code{transmute()} keeps the newly created variables
along with index and keys;
}
\details{
These column-wise verbs from dplyr have an additional argument of \code{.drop = FALSE}
for tsibble. The index variable cannot be dropped for a tsibble. If any key
variable is changed, it will validate whether it's a tsibble internally.
Turning \code{.drop = TRUE} converts to a tibble first and then do the operations.
\itemize{
\item \code{summarise()} will not collapse on the index variable.
}
}
\seealso{
\link[dplyr:mutate]{dplyr::mutate}

\link[dplyr:transmute]{dplyr::transmute}
}
