% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-preprocess.R
\name{embed_timeseries}
\alias{embed_timeseries}
\title{Embedding a Time Series}
\usage{
embed_timeseries(timeseries, embedding.dimension)
}
\arguments{
\item{timeseries}{a time series of class \"xts\".}

\item{embedding.dimension}{an integer specifying the embedding dimension.}
}
\value{
An embedded time series
}
\description{
This function embeds a time series into an Euclidean space.
This implementation is based on the function \code{embed} of
\strong{stats} package and has theoretical backgroung on
reconstruction of attractors (see Takens, 1981).
This shape transformation of the series allows for
the use of any regression tool available to learn
the time series. The assumption is that there are no long-term
dependencies in the data.
}
\examples{
\dontrun{
require(xts)
ts <- as.xts(rnorm(100L), order.by = Sys.Date() + rnorm(100L))
embedded.ts <- embed.timeseries(ts, 20L)
}

}
\seealso{
\code{\link[stats]{embed}} for the details of the embedding procedure.
}
