% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_c.R
\name{ts_c}
\alias{ts_c}
\title{Collect Time Series}
\usage{
ts_c(...)
}
\arguments{
\item{...}{ts-boxable time series, objects of class \code{ts}, \code{xts}, \code{data.frame}, \code{data.table}, or \code{tibble}.}
}
\value{
a ts-boxable object of the same class as the input.
If series of different classes are combined, the class of the first series is
used (if possible).
}
\description{
Collect time series as multiple time series.
}
\details{
In data frame objects, multiple time series are stored in a long data frame.
In \code{ts} and \code{xts} objects, time series are combined horizontally.
}
\examples{
head(ts_c(ts_df(EuStockMarkets), AirPassengers))

# labeling
x <- ts_c(
  `International Airline Passengers` = ts_xts(AirPassengers),
  `Deaths from Lung Diseases` = ldeaths
)
head(x)

}
\seealso{
\link{ts_bind}, to bind multiple time series to a single series.
}
