% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_files.R
\name{simulate_resp_files}
\alias{simulate_resp_files}
\title{Simulate Response Data Files From Longitudinal Illusory Truth Study}
\usage{
simulate_resp_files(
  nsubj,
  phase_eff = c(0, 0, 0, 0),
  path,
  overwrite = FALSE,
  p_too_fast = 0.01,
  p_too_slow = 0.01,
  p_incomplete = 0.01,
  p_cheat = 0.01,
  p_no_consent_all = 0.01,
  p_no_consent_phase = 0.01,
  p_nonnative = 0.01,
  p_repeater = 0.01,
  duration_range_1 = c(180, 2400),
  duration_range_all = c(60, 1800)
)
}
\arguments{
\item{nsubj}{Number of subjects; must be a multiple of 8.}

\item{phase_eff}{A four-element vector giving the size of the
illusory truth effect at each of the four phases (on the log odds
scale). Use \code{rep(0, 4)} for testing Type I error rate. A
value of .14 gives an effect of approximately 1/10 of a scale
point.}

\item{path}{Path to subdirectory where resulting files will be
stored; will be created if it does not exist.}

\item{overwrite}{Whether to overwrite the subdirectory if it
exists.}

\item{p_too_fast}{Probability that the respondent completed the
task faster than the cutoff time ('Duration (in seconds)' less
than \code{duration_range_1[1]} for Phase 1, less than
\code{duration_range_all[1]} for all other phases).}

\item{p_too_slow}{Probability that the respondent completed the
task slower than the cutoff time ('Duration (in seconds)' greater
than \code{duration_range_1[2]} for Phase 1, greater than
\code{duration_range_all[2]} for all other phases).}

\item{p_incomplete}{Probability that the respondent failed to complete the task ('Finished' = FALSE).}

\item{p_cheat}{Probability that the respondent looked up answers
('cheat' = "Yes...")}

\item{p_no_consent_all}{Probability the respondent refused consent
to the full study.}

\item{p_no_consent_phase}{Probability the respondent refused
consent to a phase of the study.}

\item{p_nonnative}{Probability the respondent is not a native
English speaker.}

\item{p_repeater}{Probability that the respondent just pressed the
same key over and over for at least one phase.}

\item{duration_range_1}{Two-element vector giving the range of
acceptable task durations for Phase 1.}

\item{duration_range_all}{Two-element vector giving the range of
acceptable task durations for Phases 2, 3, and 4.}
}
\value{
A character vector with the names of the data files.
}
\description{
Simulate Response Data Files From Longitudinal Illusory Truth Study
}
\details{
Simulates response data and writes a set of CSV files out
  to \code{path} in Qualtrics format. The file names are of the
  format \code{PXLY.csv}, where X is the phase number (1-4) and Y
  is the list number (1-8). So P2L6.csv is the file for phase 2 of
  list 6. When we ran a pilot study, we discovered that the data
  files had a somewhat different structure from this, but we
  nevertheless opted to retain this function rather than rewriting
  it to match the new format.
}
\examples{
td <- tempdir()
simulate_resp_files(40, path = td, overwrite = TRUE)
dir(td) # show the response files
unlink(td, TRUE, TRUE) # cleanup

}
