% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survfit_phregr.R
\name{survfit_phregr}
\alias{survfit_phregr}
\title{Survival Curve for Proportional Hazards Regression Models}
\usage{
survfit_phregr(
  fit_phregr,
  newdata,
  sefit = TRUE,
  conftype = "log-log",
  conflev = 0.95
)
}
\arguments{
\item{fit_phregr}{The output from the \code{phregr} call.}

\item{newdata}{A data frame with the same variable names as those that
appear in the \code{phregr} call. For right-censored data, one curve is
produced per row to represent a cohort whose covariates correspond to
the values in \code{newdata}. For counting-process data, one curve is
produced per \code{id} in \code{newdata} to present the survival curve
along the path of time-dependent covariates at the observed event
times in the data used to fit \code{phregr}.}

\item{sefit}{Whether to compute the standard error of the survival
estimates.}

\item{conftype}{The type of the confidence interval. One of \code{"none"},
\code{"plain"}, \code{"log"}, \code{"log-log"} (the default), or
\code{"arcsin"}. The \code{arcsin} option bases the intervals on
\code{asin(sqrt(surv))}.}

\item{conflev}{The level of the two-sided confidence interval for
the survival probabilities. Defaults to 0.95.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{id}: The id of the subject for counting-process data with
time-dependent covariates.
\item \code{time}: The observed times in the data used to fit
\code{phregr}.
\item \code{nrisk}: The number of patients at risk at the time point in the
data used to fit \code{phregr}.
\item \code{nevent}: The number of patients having event at the time point
in the data used to fit \code{phregr}.
\item \code{cumhaz}: The cumulative hazard at the time point.
\item \code{surv}: The estimated survival probability at the time point.
\item \code{sesurv}: The standard error of the estimated survival probability.
\item \code{lower}: The lower confidence limit for survival probability.
\item \code{upper}: The upper confidence limit for survival probability.
\item \code{conflev}: The level of the two-sided confidence interval.
\item \code{conftype}: The type of the confidence interval.
\item \code{covariates}: The values of covariates based on \code{newdata}.
\item \code{stratum}: The stratum of the subject.
}
}
\description{
Obtains the predicted survivor function for a proportional
hazards regression model.
}
\details{
If \code{newdata} is not provided and there is no covariate, survival
curves based on the \code{basehaz} data frame will be produced.
}
\examples{

library(dplyr)

# Example 1 with right-censored data
fit1 <- phregr(data = rawdata \%>\% filter(iterationNumber == 1) \%>\%
                 mutate(treat = 1*(treatmentGroup == 1)),
               stratum = "stratum",
               time = "timeUnderObservation", event = "event",
               covariates = "treat")

surv1 <- survfit_phregr(fit1,
                        newdata = data.frame(
                          stratum = as.integer(c(1,1,2,2)),
                          treat = c(1,0,1,0)))

# Example 2 with counting process data and robust variance estimate
fit2 <- phregr(data = heart \%>\% mutate(rx = as.numeric(transplant) - 1),
               time = "start", time2 = "stop", event = "event",
               covariates = c("rx", "age"), id = "id", robust = TRUE)

surv2 <- survfit_phregr(fit2,
                        newdata = data.frame(
                          id = c(4,4,11,11),
                          age = c(-7.737,-7.737,-0.019,-0.019),
                          start = c(0,36,0,26),
                          stop = c(36,39,26,153),
                          rx = c(0,1,0,1)))

}
\references{
Terry M. Therneau and Patricia M. Grambsch.
Modeling Survival Data: Extending the Cox Model.
Springer-Verlag, 2000.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
