% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{nscpp}
\alias{nscpp}
\title{Natural Cubic Spline Basis}
\usage{
nscpp(
  x = NA_real_,
  df = NA_integer_,
  knots = NA_real_,
  intercept = 0L,
  boundary_knots = NA_real_
)
}
\arguments{
\item{x}{A numeric vector representing the predictor variable.
Missing values are allowed.}

\item{df}{Degrees of freedom, specifying the number of columns in
the basis matrix. If \code{df} is provided, the function selects
\code{df - 1 - intercept} internal knots based on appropriate
quantiles of \code{x}, ignoring any missing values.}

\item{knots}{A numeric vector specifying the internal breakpoints
that define the spline. If provided, the number of degrees of
freedom will be determined by the length of \code{knots}.}

\item{intercept}{A logical value indicating whether to include an
intercept in the basis. The default is \code{FALSE}.}

\item{boundary_knots}{A numeric vector of length 2 specifying the
boundary points where the natural boundary conditions are applied
and the B-spline basis is anchored. If not supplied, the default
is the range of non-missing values in \code{x}.}
}
\value{
A matrix with dimensions \code{c(length(x), df)}, where
\code{df} is either provided directly or computed as
\code{length(knots) + 1 + intercept} when \code{knots} are supplied.
The matrix contains attributes that correspond to the arguments
passed to the \code{nscpp} function.
}
\description{
Computes the B-spline basis matrix for a natural cubic
spline.
}
\examples{

nscpp(women$height, df = 5)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
