% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_variables.R
\name{plot.cluster_variables}
\alias{plot.cluster_variables}
\title{Plots tree with correlation values}
\usage{
\method{plot}{cluster_variables}(x, p = NULL, show_labels = TRUE, axis_lab_size = 10, text_size = 3, ...)
}
\arguments{
\item{x}{\code{cluster_variables} or \code{hclust} object}

\item{p}{correlation value for cutoff level, if not NULL, cutoff line will
be drawn}

\item{show_labels}{if TRUE, plot will have annotated axis Y}

\item{axis_lab_size}{size of labels on axis Y, if applicable}

\item{text_size}{size of labels annotating values of correlations}

\item{...}{other parameters}
}
\value{
plot
}
\description{
Plots tree that illustrates the results of cluster_variables function.
}
\examples{
library("DALEX")
dragons_data <- dragons[,c(2,3,4,7,8)]
cv <- cluster_variables(dragons_data, clust_method = "complete")
plot(cv, p = 0.7)

}
