% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc3.test.R
\name{roc3.test}
\alias{roc3.test}
\title{Statistical test function for computing multiple tests on three-class ROC data}
\usage{
roc3.test(dat, type = c("ROC", "VUS", "Bootstrap"), paired = FALSE,
  conf.level = 0.95, n.boot = 1000, p.adjust = FALSE)
}
\arguments{
\item{dat}{A data frame of the following structure: The first column
represents a factor with three levels, containing the true class membership
of each measurement. The levels are ordered according to the convention of
higher values for more severe disease status.}

\item{type}{A character, specifying which tests are applied to \code{dat}.
\code{"ROC"} implies the trinormal based ROC test, \code{"VUS"} the trinormal
VUS test and \code{"Bootstrap"} the Bootstrap test.}

\item{paired}{A logical indicating whether data arose from a paired setting.
If data is paired, each class must have equal sample size for both classifiers.}

\item{conf.level}{A numeric value between 0 and 1 yielding the significance
level \eqn{alpha=1-\code{conf.level}}.}

\item{n.boot}{An integer incicating the number of Bootstrap replicates sampled
to obtain the variance of the VUS. Default is 1000.}

\item{p.adjust}{A logical, indicating whether a FDR adjustment
should be applied to the p-values. Default is \code{FALSE}.}
}
\value{
A list with components:
  \item{Overview}{a data frame with number of columns according to number of
  markers. Rows contain the following information about the makers:
  \enumerate{
    \item Index according to smallest VUS
    \item VUS
    \item P-values of statistical test specified by \code{type}
    \item Number of NA's
    }}
  \item{O.orig}{the unsorted \code{Overview.}}
  \item{P.values}{a list, containing the upper triangular matrices of the optionally adjusted
  p-values of the statistical tests chosen by \code{type}.}
  \item{Test.Values}{a list, containing the upper triangular matrices of the
  test values of the statistical tests chosen by \code{type}.}
}
\description{
A statistical test function that assesses three-class ROC data with the
trinormal based ROC test, the trinormal VUS test and the Bootstrap test.
}
\details{
For the preliminary assessment of a classifier, different
  statistical tests have been proposed in the literature. This function can
  be used for either comparison of single classifiers to a null hypothesis of
  being not better than a random allocation function or comparison of two
  classifiers under the null hypothesis of having equal discriminatory power.
  Depending on the specification of the user, (s)he can apply the trinormal
  based ROC test (LINK), the test developed by Xiong et. al. or the Bootstrap
  test or any combination of these tests. More information of the specific
  tests can be obtained by calling \code{?functionname}. If more than two
  markers are present, a pairwise comparison between each marker is realized.
}
\section{Note}{
 If \code{type = "Bootstrap"}, the Bootstrap test is evaluated. This
may take some time, especially with sample sizes >= 100.
}

\examples{
\donttest{
data(krebs)
roc3.test(krebs, type = c("ROC", "VUS"), paired = TRUE)
}
}
