% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/innovtrend.R
\name{innovtrend}
\alias{innovtrend}
\title{Innovative Trend Analysis}
\usage{
innovtrend(x)
}
\arguments{
\item{x}{- Time series data vector}
}
\value{
S  - Slope of the trend

D  - Trend indicator

CLlower90  - Lower Cofidence Limit at 90 percent
CLupper90  - Uppler Cofidence Limit at 90 percent

CLlower95  - Lower Cofidence Limit at 95 percent
CLupper95  - Uppler Cofidence Limit at 95 percent

CLlower99  - Lower Cofidence Limit at 99 percent
CLupper99  - Uppler Cofidence Limit at 99 percent
}
\description{
Innovative trend analysis method proposed by Zekai Sen (2011) is implemented in this function.
}
\details{
If the data points lay on 1:1 line, there is no trend in the data. If the data points exist in the top triangle, it is indicative of positive trend. If the data lies in the bottom triangle, it indicates negative trend in the data.
}
\examples{
x<-c(Nile)
innovtrend(x)

}
\references{
Şen Z (2011) Innovative Trend Analysis Methodology. J Hydrol Eng 17:1042–1046. <doi: 10.1061/(ASCE)HE.1943-5584.0000556>.
}
