% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{map_plot}
\alias{map_plot}
\title{Apply a function to each element of a vector and return a vector of plots}
\usage{
map_plot(.x, .f, ...)
}
\arguments{
\item{.x}{a list or atomic vector (see \code{\link[purrr]{map}} for details)}

\item{.f}{a function, formula, or atomic vector (see \code{\link[purrr]{map}} for details)}

\item{...}{additional arguments passed on to .f (see \code{\link[purrr]{map}} for details)}
}
\description{
Apply a function to each element of a vector and return a vector of plots
}
\details{
See \code{\link[purrr]{map}}
}
\examples{
\donttest{
library(dplyr)
library(tidyr)
library(purrr)
library(rbokeh)
library(gapminder)

# nest gapminder data by country
by_country <- gapminder \%>\%
  group_by(country, continent) \%>\%
  nest()

# add in a plot column with map_plot
by_country <- by_country \%>\% mutate(
  panel = map_plot(data,
    ~ figure(xlim = c(1948, 2011), ylim = c(10, 95), width = 300, tools = NULL) \%>\%
        ly_points(year, lifeExp, data = .x, hover = .x)
  ))

# plot it
by_country \%>\%
  trelliscope("gapminder", nrow = 2, ncol = 7)

# example using mpg data
ggplot2::mpg \%>\%
  group_by(manufacturer, class) \%>\%
  nest() \%>\%
  mutate(panel = map_plot(data,
    ~ figure(xlab = "City mpg", ylab = "Highway mpg") \%>\%
        ly_points(cty, hwy, data = .x))) \%>\%
  trelliscope(name = "city_vs_highway_mpg")
}
}
