% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{query-matches-and-captures}
\alias{query-matches-and-captures}
\alias{query_matches}
\alias{query_captures}
\title{Query matches and captures}
\usage{
query_matches(x, node, ..., range = NULL)

query_captures(x, node, ..., range = NULL)
}
\arguments{
\item{x}{\verb{[tree_sitter_query]}

A query.}

\item{node}{\verb{[tree_sitter_node]}

A node to run the query over.}

\item{...}{These dots are for future extensions and must be empty.}

\item{range}{\verb{[tree_sitter_range / NULL]}

An optional range to restrict the query to.}
}
\description{
These two functions execute a query on a given \code{node}, and return the
captures of the query for further use. Both functions return the same
information, just structured differently depending on your use case.
\itemize{
\item \code{query_matches()} returns the captures first grouped by \emph{pattern}, and
further grouped by \emph{match} within each pattern. This is useful if you
include multiple patterns in your query.
\item \code{query_captures()} returns a flat list of captures ordered by their node
location in the original text. This is normally the easiest structure to
use if you have a single pattern without any alternations that would
benefit from having individual captures split by match.
}

Both also return the capture name, i.e. the \verb{@name} you specified in your
query.
}
\section{Predicates}{


There are 3 core types of predicates supported:
\itemize{
\item \verb{#eq? @capture "string"}
\item \verb{#eq? @capture1 @capture2}
\item \verb{#match? @capture "regex"}
}

Each of these predicates can also be inverted with a \verb{not-} prefix, i.e.
\verb{#not-eq?} and \verb{#not-match?}.
\subsection{String double quotes}{

The underlying tree-sitter predicate parser requires that strings supplied
in a query must use double quotes, i.e. \code{"string"} not \code{'string'}. If you
try and use single quotes, you will get a query error.
}

\subsection{\verb{#match?} regex}{

The regex support provided by \verb{#match?} is powered by \code{\link[=grepl]{grepl()}}.

Escapes are a little tricky to get right within these match regex strings.
To use something like \verb{\\s} in the regex string, you need the literal text
\verb{\\\\s} to appear in the string to tell the tree-sitter regex engine to escape
the backslash so you end up with just \verb{\\s} in the captured string. This
requires putting two literal backslash characters in the R string itself,
which can be accomplished with either \code{"\\\\\\\\s"} or using a raw string like
\code{r'["\\\\s"]'} which is typically a little easier. You can also write your
queries in a separate file (typically called \code{queries.scm}) and read them
into R, which is also a little more straightforward because you can just
write something like \verb{(#match? @id "^\\\\s$")} and that will be read in
correctly.
}
}

\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
text <- "
foo + b + a + ab
and(a)
"

source <- "(identifier) @id"

language <- treesitter.r::language()

query <- query(language, source)
parser <- parser(language)
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# A flat ordered list of captures, that's most useful here since
# we only have 1 pattern!
captures <- query_captures(query, node)
captures$node
\dontshow{\}) # examplesIf}
}
