% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/medTree.R
\name{medTree}
\alias{medTree}
\title{Geometric median tree function}
\usage{
medTree(x, groups = NULL, lambda = 0, weights = rep(1, length(x)),
  return.lambda.function = FALSE, save.memory = FALSE)
}
\arguments{
\item{x}{An object of the class multiPhylo, containing the trees for which the median tree will be computed.}

\item{groups}{an optional factor defining groups of trees; if provided, one median tree will be seeked for each group.}

\item{lambda}{a number in [0,1] which specifies the extent to which topology (default, with lambda=0)  or branch lengths (lambda=1) are emphasised. This argument is ignored if \code{return.lambda.function=TRUE}.}

\item{weights}{A vector of weights for the trees. Defaults to a vector of 1's so that all trees are equally weighted, but can be used to encode likelihood, posterior probabilities or other characteristics.}

\item{return.lambda.function}{If true, a function that can be invoked with different lambda values is returned.
This function returns the vector of metric values for the given lambda.}

\item{save.memory}{A flag that saves a lot of memory but increases the execution time (not compatible with return.lambda.function=TRUE).}
}
\value{
A list with the median metric vector, distances, indices of the tree(s) that are closest to the median tree and the value of this distance or a function that produces this list for a given value of lambda. If groups are provided, then one list is returned for each group.
}
\description{
Finds the geometric median of a set of trees according to the Kendall Colijn metric.
}
\examples{
## EXAMPLE WITH WOODMICE DATA
data(woodmiceTrees)

## LOOKING FOR A SINGLE MEDIAN
## get median tree(s)
res <- medTree(woodmiceTrees)
res

## plot first tree
med.tree <- res$trees[[1]]
plot(med.tree)

## LOOKING FOR MEDIANS IN SEVERAL CLUSTERS
## identify 6 clusters
groves <- findGroves(woodmiceTrees, nf=3, nclust=6)

## find median trees
res.with.grp <- medTree(woodmiceTrees, groves$groups)

## there isone output per cluster
names(res.with.grp)

## get the first median of each
med.trees <- lapply(res.with.grp, function(e) ladderize(e$trees[[1]]))

## plot trees
par(mfrow=c(2,3))
for(i in 1:length(med.trees)) plot(med.trees[[i]], main=paste("cluster",i))
}
\author{
Jacob Almagro-Garcia \email{nativecoder@gmail.com}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}

Thibaut Jombart \email{thibautjombart@gmail.com}
}

