#' Fictitious  Business Statistics Data
#'
#' Fictitious (aggregated) business statistics data. The index variables (\code{NACE1} to \code{NACE4}) are derived from the Statistical Classification of Economic Activities in the European Community (NACE). The variables \code{turnover(.prev)} and \code{employees(.prev)} have values for NACE codes in the business economy domain only.
#'
#' @name business
#' @references 
#' \href{http://en.wikipedia.org/wiki/Statistical_Classification_of_Economic_Activities_in_the_European_Community}{Statistical Classification of Economic Activities in the European Community (NACE)}
#' \href{http://epp.eurostat.ec.europa.eu/portal/page/portal/european_business/introduction}{Eurostat - Structural business statistics (SBS)}
{}

#' GNI 2010 Data
#' 
#' Gross national income (per capita) in dollars per country in 2010.
#'
#' @name GNI2010
#' @references 
#' \href{http://data.worldbank.org/data-catalog/health-nutrition-and-population-statistics}{Website of The World Bank - Health Nutrition and Population Statistics}
{}