% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nds-methods.R
\name{getNdsPtids}
\alias{getNdsPtids}
\title{Get post-nodes to tips for multiple nodes}
\usage{
getNdsPtids(tree, ids, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Return node ids for connecting \code{ids} to kids.
}
\details{
Returns a list, parallizable.
}
\examples{
library(treeman)
tree <- randTree(10)
# get all nodes to tip for all nodes
getNdsPtids(tree, ids=tree['nds'])
}
\seealso{
\code{\link{getNdPtids}}, 
\code{\link{getNdPrids}}, 
\code{\link{getNdsPrids}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
