% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-methods.R
\name{getNdsLng}
\alias{getNdsLng}
\title{Get lineage for multiple nodes}
\usage{
getNdsLng(tree, ids, ...)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}

\item{...}{\code{plyr} arguments}
}
\description{
Return unique taxonyms for connecting \code{ids} to root.
}
\details{
Returns a list, parallelizable.
}
\examples{
library(treeman)
data(mammals)
# return human and gorilla lineages
getNdLng(mammals, id=c('Homo_sapiens', 'Gorilla_gorilla'))
}
\seealso{
\code{\link{getNdLng}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}

