% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_tree.R
\name{position_nodes}
\alias{position_nodes}
\title{Creates smart node layout.}
\usage{
position_nodes(plot_data, terminal_data, custom_layout, lev_fac, panel_space)
}
\arguments{
\item{plot_data}{Dataframe output of `ggparty:::get_plot_data()`.}

\item{terminal_data}{Dataframe of terminal node information including id
and raw terminal node size.}

\item{custom_layout}{Dataframe with 3 columns: id, x and y
for manually input custom layout.}

\item{lev_fac}{Relative weight of child node positions
according to their levels, commonly ranges from 1 to 1.5.
1 for parent node perfectly in the middle of child nodes.}

\item{panel_space}{Spacing between facets relative to viewport,
recommended to range from 0.001 to 0.01.}
}
\value{
Dataframe with 3 columns: id, x and y of smart layout
combined with custom_layout.
}
\description{
Create node layout using a bottom-up approach (literally) and
overwrites ggparty-precomputed positions in plot_data.
}
