% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_tree.R
\name{prediction_df}
\alias{prediction_df}
\title{Apply the predicted tree on either new test data or training data.}
\usage{
prediction_df(dat, fit, data_test, task, clust_samps, clust_target)
}
\arguments{
\item{dat}{Tidy dataset with dependent variable labelled 'my_target'.}

\item{fit}{constparty object of the decision tree.}

\item{data_test}{Tidy test dataset. If NULL, heatmap displays (training) `data`.}

\item{task}{Character string indicating the type of problem,
either 'classification' (categorical outcome) or 'regression' (continuous outcome).}

\item{clust_samps}{Logical. If TRUE, hierarhical clustering would be performed
among samples within each leaf node.}

\item{clust_target}{Logical. If TRUE, target/label is included in hierarchical clustering
of samples within each leaf node and might yield a more interpretable heatmap.}
}
\value{
A dataframe of prediction values with scaled columns
and clustered samples.
}
\description{
Select features with p-value (computed from decision tree) < `p_thres`
or all features if `show_all_feats == TRUE`.
}
