% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeda-functions.R
\name{predict.treeda}
\alias{predict.treeda}
\title{Predict using new data}
\usage{
\method{predict}{treeda}(object, newdata, newresponse = NULL,
  check.consist = TRUE, ...)
}
\arguments{
\item{object}{Output from \code{\link{treeda}} function.}

\item{newdata}{New data.}

\item{newresponse}{New response vector, not required.}

\item{check.consist}{Check the consistency between the tree and
predictor matrix?}

\item{...}{Not used.}
}
\value{
A list containing the projections of the new data onto the
    discriminating axes (\code{projections}), the predicted classes
    (\code{classes}), and the rss (\code{rss}, only included if the
    ground truth for the responses is available).
}
\description{
Given a fitted \code{\link{treeda}} model, get the predicted
classes and projections onto the discriminating axes for new data.
}
\examples{
data(treeda_example)
out.treeda = treeda(response = treeda_example$response,
    predictors = treeda_example$predictors,
    tree = treeda_example$tree,
    p = 1)
## Here we are predicting on the training data, in general this
## would be done on a held out test set
preds = predict(out.treeda, newdata = treeda_example$predictors,
    newresponse = treeda_example$response)
## make a confusion matrix
table(preds$classes, treeda_example$response)
}
