% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convexity.R
\name{convexity}
\alias{convexity}
\title{Calculate the convexity of a bond}
\usage{
convexity(yields, maturity, format_out = "xts")
}
\arguments{
\item{yields}{a series of yields}

\item{maturity}{constant bond maturity in years}

\item{format_out}{xts or tibble}
}
\value{
The convexity or a series of convexities of a bond with the given yield and maturity
}
\description{
Calculates the convexity of a bond.

This function is normally used in combination with total_return() to compute bond total returns.
}
\details{
This function is normally used in combination with total_return() to compute bond total returns.

The convexity is the interest rate sensitivity of the modified duration.

\deqn{convexity = C_1 - C_2}{convexity = C_1 - C_2}

where

\deqn{C_1 = \frac{2}{y_t^2} (1-{z_t}^{-2M})}{C_1 = 2/(y_t^2) * (1-z_t^(-2M))}
\deqn{C_2 = \frac{2M}{y_t}{z_t}^{-2M-1}}{C_2 = 2M/y_t * z_t^(-2M-1)}
\deqn{z_t = 1+\frac{y_t}{2}}{z_t = 1 + y_t/2}

\eqn{M}{M} is the maturity in years (e.g. 10), \eqn{y_t}{t_y} is the yield at time \eqn{t}{t}.
}
