% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssRenameVariables.R
\name{xpssRenameVariables}
\alias{xpssRenameVariables}
\title{Renaming Variables}
\usage{
xpssRenameVariables(x, oldVarNames = NULL, newVarNames = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{"xpssFrame"}.}

\item{oldVarNames}{atomic character or character vector with the names of the variables to rename. oldVarNames must be a variable that already exists in the data set.}

\item{newVarNames}{atomic character or character vector with the new variable names.}
}
\value{
Returns the data with the renamed variables.
}
\description{
R implementation of the SPSS \code{RENAME VARIABLES} function. xpssRenameVariables renames variables within an exisiting data.frame or xpssFrame object.
}
\details{
Modifies names of one or more variables within a selected dataset. The arguments oldVarNames and newVarNames must have the same length.
}
\examples{
data(fromXPSS)

xpssRenameVariables(fromXPSS,
oldVarNames= c("V1", "V2", "V3"),
newVarNames= c("Manufacturer", " Car Type", "Country"))
}
\author{
Andreas Wygrabek
}

