% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rapriori.R
\name{rapriori}
\alias{rapriori}
\alias{rapriori.default}
\alias{rapriori.units}
\alias{rapriori.transfR}
\title{Net rainfall a priori estimation}
\usage{
rapriori(Qobs, ...)

\method{rapriori}{default}(Qobs, area, lagtime, deltat, ...)

\method{rapriori}{units}(Qobs, area, lagtime, deltat, ...)

\method{rapriori}{transfR}(Qobs, verbose = TRUE, ...)
}
\arguments{
\item{Qobs}{vector of discharge value or object of class \code{transfR}. If no unit is provided,
\code{Qobs} is assumed to be in [m3/s].}

\item{...}{further arguments passed to or from other methods}

\item{area}{drainage area of the catchment. If no unit is provided, \code{area} is assumed to be in [km2].}

\item{lagtime}{lag time value of the catchment. If no unit is provided, \code{lagtime} is assumed to be in [h].}

\item{deltat}{time step of the time series. If no unit is provided, \code{deltat} is assumed to be in [min].}

\item{verbose}{boolean indicating if information messages should be written to the console}
}
\value{
An object of the same class of \code{Qobs}. If \code{Qobs} is a transfR object,
the same transfR object incremented by the new "RnAp" computed attributes.
}
\description{
A priori estimate of net rainfall as required for the inversion.
}
\details{
The function estimates an a priori of the net rainfall from Qobs. It converts Qobs to specific
discharge and removes the delay caused by transfer time in the river network (given by \code{lagtime}
and that could be estimated from the function \link{lagtime}). If an object of class \code{transfR} is provided,
\code{area} is estimated from its \code{st} attribute. Results are stored as a new space-time attribute,
called "RnAp", in the \code{transfR} object.
}
\examples{
data(Oudon)
icatch <- 1
Qobs <- Oudon$obs[["Qobs"]][,icatch]
Qspec <- units::set_units(Qobs/st_area(st_geometry(Oudon$obs)[icatch]), "mm/h")
deltat <- units::set_units(1,"h")
uc <- velocity(hl = Oudon$hl[[icatch]])
uh <- uh(hl = Oudon$hl[[icatch]], uc = uc, deltat = deltat)$prob
RnAp <- rapriori(Qobs = Qspec, lagtime = lagtime(hl = Oudon$hl[[icatch]], uc = uc),
deltat = deltat)
}
