% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transGFM.R
\name{transGFM}
\alias{transGFM}
\title{Single source transfer learning for generalized factor models}
\usage{
transGFM(
  source_data,
  target_data,
  r,
  data_type = "count",
  lambda_seq = seq(0, 10, by = 1),
  K_cv = 3,
  sigma2 = 1,
  max_iter_cjmle = 30,
  max_iter_refine = 30,
  max_iter_nuclear = 30,
  verbose = FALSE
)
}
\arguments{
\item{source_data}{Source data matrix (may contain missing values coded as NA)}

\item{target_data}{Target data matrix (complete)}

\item{r}{Number of factors}

\item{data_type}{Type of data: "continuous", "count", or "binary"}

\item{lambda_seq}{Sequence of lambda values for CV (default: seq(0, 10, by = 1))}

\item{K_cv}{Number of CV folds (default: 3)}

\item{sigma2}{Variance parameter for continuous data (default: 1)}

\item{max_iter_cjmle}{Maximum iterations for CJMLE (default: 30)}

\item{max_iter_refine}{Maximum iterations for refinement (default: 30)}

\item{max_iter_nuclear}{Maximum iterations for nuclear MLE (default: 100)}

\item{verbose}{Print progress information (default: FALSE)}
}
\value{
List containing final estimate M_trans and intermediate results
}
\description{
Single source transfer learning for generalized factor models
}
\examples{
# Generate Poisson data
set.seed(2025)

# Source data (100 x 100 with 10\% missing)
n1 <- 100; p1 <- 100; r <- 2
F_source <- matrix(runif(n1 * r, min = -2, max = 2), n1, r)
B_source <- matrix(runif(p1 * r, min = -2, max = 2), p1, r)
M_source <- F_source \%*\% t(B_source)
lambda_source <- exp(M_source)
X_source <- matrix(rpois(n1 * p1, as.vector(lambda_source)), n1, p1)

# Add 10\% missing values to source
n_missing <- floor(n1 * p1 * 0.1)
missing_idx <- sample(n1 * p1, n_missing)
X_source[missing_idx] <- NA

# Target data (50 x 50, complete)
n0 <- 50; p0 <- 50
M_target_true <- M_source[1:n0, 1:p0]
lambda_target <- exp(M_target_true)
X_target <- matrix(rpois(n0 * p0, as.vector(lambda_target)), n0, p0)

# Run transGFM
result <- transGFM(
  source_data = X_source,
  target_data = X_target,
  r = 2,
  data_type = "count",
  lambda_seq = seq(0, 5, by = 1),
  K_cv = 3,
  verbose = FALSE
)

# Check results
print(paste("Optimal lambda:", result$optimal_lambda))
print(paste("Final relative error:",
            relative_error(result$M_trans, M_target_true)))

}
