% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpterms.R
\name{lpterms.tramME}
\alias{lpterms.tramME}
\title{Get inidvidual terms of the linear predictor and their confidence
intervals}
\usage{
\method{lpterms}{tramME}(
  object,
  newdata = model.frame(object)[, -1L],
  term = c("baseline", "shift"),
  type = c("trafo", "distribution", "survivor", "cumhazard"),
  confidence = c("none", "interval", "band"),
  level = 0.95,
  K = 50,
  ...
)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{newdata}{A \code{data.frame} containing the values at which the
functions are evaluated.}

\item{term}{The names or identifiers of the terms we want to evaluate.}

\item{type}{The scale on which the functions are evaluated.}

\item{confidence}{Pointwise confidence interval or confidence band.}

\item{level}{Confidence level.}

\item{K}{Integer, number of points of the grid the function is
evaluated on.}

\item{...}{Additional parameters (for consistency with generic)}
}
\value{
Matrix or list of matrices containing the point estimates and the
  confidence intervals.
}
\description{
\code{term} can be variable groups (baseline/interacting or shift) or names of
variables.
}
\note{
Currently it only takes the fixed effects into account when calculating
  intervals (either pointwise confidence intervals or confidence bands).
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
tr <- lpterms(fit, type = "distribution", confidence = "interval", K = 100)
}
