\name{ltmatrices}
\alias{ltmatrices}
\alias{diagonals}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Lower Triangular Matrices
}
\description{
  Storge of and computations on multiple lower triangular matrices
}
\usage{
ltmatrices(x, diag = FALSE, byrow = FALSE, names = TRUE)
diagonals(x, ...)
}
\arguments{
  \item{x}{a numeric matrix, each row is interpreted as the elements of a
lower triangular matrix in row order (\code{byrow} being \code{TRUE}) or
column order (otherwise). The matrices may contain non-unit diagonals (when
\code{diag} is \code{TRUE}).
}
  \item{diag}{logical; \code{x} contains non-unit diagonals if \code{TRUE}.
}
  \item{byrow}{logical; \code{x} is in row order if \code{TRUE}.
}
  \item{names}{an optional vector of names, autogenerated if \code{TRUE}.
}
  \item{\dots}{additional arguments.}
}
\details{
Currently only for internal use.
}
\value{
An object of class \code{ltmatrices}
}
\examples{
x <- matrix(runif(30), ncol = 3)
ltmatrices(x, diag = FALSE, byrow = TRUE)
}
\keyword{matrix}
